function AISMN_PlaceDynamite::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %object.mountImage("Dynamitecarry", 2);
   %object.playThread(0, "carry");
   
   $DynamiteBuilding = false;
   %data.disableToolActions();
   
   SetPathToSpot(%data, GetParameterX(%data), GetParameterY(%data));
}

function AISMN_PlaceDynamite::OnExit(%this, %data)
{
}

function AISMN_PlaceDynamite::Update(%this, %data)
{
   %object = GetThisObject(%data);
   if (!IsFollowingPath(%data))
   {
      %object.unmountImage(2);
      ReturnValue(%data, 0);
      return;
   }
   
   ReturnValue(%data, -1);
}


function AISMN_DropDynamite::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);   
   %object.playThread(0, "pickup");
}

function AISMN_DropDynamite::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   toolsOnDynamitePlace(toolsCreateTool($INV_DYNAMITE), %object.getPosition(), %object);
   
   %object.stopThread(0);
   %object.playThread(0, "root");
}

function AISMN_DropDynamite::Update(%this, %data)
{
   if (TimeInNode(%data) > 0.5)
   {
      if (%data.getActionCount() == 1)
      {
         ReturnValue(%data, 1);
      }
      else
      {
         // check if the tools need to be reenabled and the
         // character's base outfit should also be restored
         %nextAction = %data.getNextAction();
         if (%nextAction !$= "dynamite")
         {
            RestoreCharacterOutfit(%data);
            %data.enableToolActions();
         }
         ReturnValue(%data, 0);
      }
      return;
   }
   
   ReturnValue(%data, -1);
}



function AISMN_HideFromDynamite::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %datablock = nameToId(Dynamite);
   
   %object.ducking = false;
   
   %posX = getWord(%object.position, 0);
   %posY = getWord(%object.position, 1);
   %posZ = getWord(%object.position, 2);

   %offset = getRandom(0, 3);
   %direction = getRandom(0, 1);
   for (%index = 0; %index < 4; %index++)
   {
      %num = (%index + %offset) % 4;
      
      %updateX = 0;
      %updateY = 0;
      %startX = %posX;
      %startY = %posY;
      switch(%num)
      {
      case 0:
         %startY -= %datablock.dmgEndRadius;
         if (%direction == 0) %updateX = 1;
         else %updateX = -1;
      case 1:
         %startX += %datablock.dmgEndRadius;
         if (%direction == 0) %updateY = 1;
         else %updateY = -1;
      case 2:
         %startY += %datablock.dmgEndRadius;
         if (%direction == 0) %updateX = 1;
         else %updateX = -1;
      case 3:
         %startX -= %datablock.dmgEndRadius;
         if (%direction == 0) %updateY = 1;
         else %updateY = -1;
      }
      
      for (%check = 0; %check < %datablock.dmgEndRadius / 2 + 1; %check++)
      {
         if (%data.pathingDistanceToLocation(%startX, %startY) != -1)
         {
            SetPathToSpot(%data, %startX, %startY);
            %object.stopThread(0);
            %object.playThread(0, "run");
            return;
         }
         
         %startX += %updateX;
         %startY += %updateY;
      }
   }
   
   %offset = getRandom(0, 3);
   for (%index = 0; %index < 4; %index++)
   {
      %num = (%index + %offset) % 4;
      
      %updateX = 0;
      %updateY = 0;
      %startX = %posX;
      %startY = %posY;
      switch(%num)
      {
      case 0:
         %startY -= %datablock.dmgEndRadius;
         if (%direction == 0) %updateX = -1;
         else %updateX = 1;
      case 1:
         %startX += %datablock.dmgEndRadius;
         if (%direction == 0) %updateY = -1;
         else %updateY = 1;
      case 2:
         %startY += %datablock.dmgEndRadius;
         if (%direction == 0) %updateX = -1;
         else %updateX = 1;
      case 3:
         %startX -= %datablock.dmgEndRadius;
         if (%direction == 0) %updateY = -1;
         else %updateY = 1;
      }
      
      for (%check = 0; %check < %datablock.dmgEndRadius / 2 + 1; %check++)
      {
         if (%data.pathingDistanceToLocation(%startX, %startY) != -1)
         {
            SetPathToSpot(%data, %startX, %startY);
            %object.stopThread(0);
            %object.playThread(0, "run");
            return;
         }
         
         %startX += %updateX;
         %startY += %updateY;
      }
   }
}

function AISMN_HideFromDynamite::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   
   // for hiding functionality
   if (%object.ducking == true)
   {
      %object.ducking = false;
      %object.stopThread(0);
      %object.playThread(0, "upfromduck");
   }
   
   /*
   // for walk away functionality
   %object.playThread(0, "root");
   */
}

function AISMN_HideFromDynamite::Update(%this, %data)
{
   %object = GetThisObject(%data);
   %datablock = nameToId(Dynamite);
   
   // for hiding functionality
   if (IsFollowingPath(%data))
   {
      if (TimeInNode(%data) >= %datablock.dmgTime - 2)
      {
         StopMoving(%data);
         %object.stopThread(0);
         %object.playThread(0, "duckandcover");
         %object.ducking = true;
      }
   }
   else if (%object.ducking == false)
   {
      %object.stopThread(0);
      %object.playThread(0, "duckandcover");
      %object.ducking = true;
   }
   
   if (TimeInNode(%data) >= %datablock.dmgTime)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   /*
   // for walk away functionality
   if (IsFollowingPath(%data) == false)
   {
      ReturnValue(%data, 0);
      return;
   }
   */
   
   ReturnValue(%data, -1);
}


function AISMN_RecoverFromDynamite::OnEnter(%this, %data)
{
}

function AISMN_RecoverFromDynamite::OnExit(%this, %data)
{
   RestoreCharacterOutfit(%data);
   %data.enableToolActions();
}

function AISMN_RecoverFromDynamite::Update(%this, %data)
{
   %object = GetThisObject(%data);

   if (TimeInNode(%data) >= 1.1)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   ReturnValue(%data, -1);
}
